/**
 * UZH Strategie-Haus Single Page Application
 * Alle Inhalte werden dynamisch im blauen Content-Bereich geladen
 */
(function() {
  'use strict';

  // Originale Bildgrösse für responsive Image Map
  const ORIGINAL_WIDTH = 1234;
  const ORIGINAL_HEIGHT = 1080;

  // Aktuelle Seite
  let currentPage = 'home';
  let currentSliderIndex = 0;

  // Alle Seiteninhalte
  const pages = {
    // HOME
    home: {
      icon: null,
      title: 'Unser Strategie-Haus',
      showHeader: true,
      content: `
        <div>
          <button class="menu-item" data-page="leitbild">
            <img src="images/5.svg" alt="">
            <span>Leitbild</span>
          </button>
          <button class="menu-item" data-page="vision">
            <img src="images/6.svg" alt="">
            <span>Vision, Mission und Werte</span>
          </button>
          <button class="menu-item" data-page="strategie">
            <img src="images/4.svg" alt="">
            <span>Strategie Bau- und Immobilienmanagement</span>
          </button>
          <button class="menu-item" data-page="leitlinien">
            <img src="images/3.svg" alt="">
            <span>Strategische Leitlinien</span>
          </button>
          <button class="menu-item" data-page="hauptziele">
            <img src="images/2.svg" alt="">
            <span>Hauptziele</span>
          </button>
          <button class="menu-item" data-page="initiativen">
            <img src="images/1.svg" alt="">
            <span>Strategische Initiativen</span>
          </button>
        </div>
      `,
      prev: null,
      next: 'leitbild'
    },

    // LEITBILD
    leitbild: {
      icon: 'images/5.svg',
      title: 'Leitbild',
      subtitle: 'Unser Selbstverständnis',
      content: `
        <div class="rich-text-block">
          <p>Das Unternehmensleitbild bildet das Dach und zeigt das Selbstverständnis und die Grundprinzipien einer Organisation.</p>
          <p>Das Leitbild besteht aus Vision und Mission sowie den Werten.</p>
          <p>Das Leitbild gibt Orientierung, Identität und Motivation.</p>
        </div>
      `,
      prev: 'home',
      next: 'vision'
    },

    // VISION
    vision: {
      icon: 'images/6.svg',
      title: 'Vision',
      subtitle: 'Dahin wollen wir',
      content: `
        <div class="rich-text-block">
          <p>Die Vision beschreibt unser Zielbild, das wir in der Zukunft erreichen wollen.</p>
          <p><strong>Unsere Vision lautet:</strong></p>
          <p>Die Universität Zürich als Stadtuniversität verfügt im internationalen Vergleich über qualitativ hochstehende infrastrukturelle und administrative Rahmenbedingungen für Forschung und Innovation sowie Lehre und Studium – attraktiv und nachhaltig.</p>
        </div>
      `,
      prev: 'leitbild',
      next: 'mission'
    },

    // MISSION
    mission: {
      icon: 'images/6.svg',
      title: 'Mission',
      subtitle: 'Darum gibt es uns',
      content: `
        <div class="rich-text-block">
          <p>Die Mission beschreibt, wie wir langfristig unsere Vision erreichen wollen.</p>
          <p><strong>Unsere Mission lautet:</strong></p>
          <p>Wir Mitarbeitenden der Direktion Immobilien und Betrieb sorgen tagtäglich für eine attraktive und qualitativ hochstehende Infrastruktur der Universität.</p>
        </div>
      `,
      prev: 'vision',
      next: 'werte'
    },

    // WERTE
    werte: {
      icon: 'images/6.svg',
      title: 'Werte',
      subtitle: 'So gehen wir miteinander um',
      content: `
        <div class="rich-text-block">
          <p>Unsere Werte spiegeln unsere Haltung in der Zusammenarbeit untereinander und mit unseren Partnern sowie in der Führung.</p>
        </div>
      `,
      slider: [
        {
          title: 'Unsere Werte spiegeln unsere Haltung:',
          content: `
            <ul>
              <li><strong>wertschätzend:</strong> Wir begegnen uns mit Respekt auf Augenhöhe.</li>
              <li><strong>miteinander:</strong> Wir vertrauen einander und unterstützen uns.</li>
              <li><strong>verbindlich:</strong> Wir tun, was wir sagen.</li>
              <li><strong>transparent:</strong> Wir sagen, was wir tun.</li>
              <li><strong>eigenverantwortlich:</strong> Wir handeln selbstständig und im Sinne des Ganzen.</li>
            </ul>
          `
        },
        {
          title: 'Unser Handeln schafft Vertrauen:',
          content: `
            <ul>
              <li><strong>vorausschauend handeln:</strong> Wir sehen Entwicklungen voraus und handeln entsprechend.</li>
              <li><strong>qualitätsbewusst arbeiten:</strong> Wir halten Abmachungen mit unseren Partnern ein.</li>
              <li><strong>lernfähig bleiben:</strong> Wir lernen aus Rückmeldungen und entwickeln uns weiter.</li>
            </ul>
          `
        },
        {
          title: 'Unser Führungsverständnis basiert auf unseren Werten:',
          content: `
            <ul>
              <li><strong>Vorbild sein:</strong> Wir übernehmen Verantwortung und gehen mit gutem Beispiel voran.</li>
              <li><strong>Vertrauen schaffen:</strong> Wir fördern eine konstruktive Feedback-Kultur und eine offene Fehler-Kultur.</li>
              <li><strong>Zusammenarbeit fördern:</strong> Wir fördern den Austausch zwischen den Teams und mit unseren Partnern.</li>
            </ul>
          `
        }
      ],
      prev: 'mission',
      next: 'strategie'
    },

    // STRATEGIE BAU- UND IMMOBILIENMANAGEMENT
    strategie: {
      icon: 'images/4.svg',
      title: 'Strategie Bau- und Immobilienmanagement',
      subtitle: '2024 – 2032',
      content: `
        <div class="rich-text-block">
          <p>Unsere Strategie 2024 – 2032 beinhaltet folgende Elemente:</p>
          <ul>
            <li><strong>10 Strategische Leitlinien</strong> – an diesen orientieren wir uns im Tagesgeschäft</li>
            <li><strong>5 Haupt- und 15 Teilziele</strong> – diese wollen wir bis 2032 erreichen</li>
            <li><strong>8 Strategische Initiativen</strong> – diese sorgen für die Zielerreichung</li>
          </ul>
          <p>Die Zielerreichung wird jährlich überprüft.</p>
        </div>
      `,
      prev: 'werte',
      next: 'leitlinien'
    },

    // STRATEGISCHE LEITLINIEN
    leitlinien: {
      icon: 'images/3.svg',
      title: '10 Strategische Leitlinien',
      subtitle: 'An diesen Leitlinien orientieren wir uns im Tagesgeschäft',
      slider: [
        { title: 'Die UZH ist eine Stadtuniversität', content: '<p>Unsere Immobilien fördern den Austausch zwischen Angehörigen der UZH und der Bevölkerung.</p><em>Beispiele: Das FORUM UZH mit dem Stadtplatz und den Cafés. Der Campus Irchel mit dem Park, den öffentlichen Verpflegungsmöglichkeiten und der Bar.</em>' },
        { title: 'Die UZH plant und betreibt bedarfsgerecht und zukunftsorientiert', content: '<p>Wir richten uns (wo möglich) nach den Bedürfnissen und Interessen der UZH-Angehörigen und denken dabei auch an die Zukunft.</p><em>Beispiel: Regelmässige Nutzergespräche</em>' },
        { title: 'Die UZH achtet stets auf Wirtschaftlichkeit', content: '<p>Wir gehen mit unserem Budget haushälterisch um – es kommt von den Steuerzahlenden.</p><em>Beispiele: Wirtschaftlichkeitsberechnungen bei Projekten, Einkauf P4U. Qualitativer Benchmark Betrieb.</em>' },
        { title: 'Die UZH orientiert sich an der Nutzungseignung', content: '<p>Wir geben Gebäude, die sich nicht für die UZH eignen, wieder frei, so dass sie für andere Zwecke genutzt werden können.</p><em>Beispiel: Wohnraumrückführung der alten Villen nach Fertigstellung FORUM UZH.</em>' },
        { title: 'Die UZH schafft Hindernisfreiheit', content: '<p>Wir setzen uns für hindernisfreien Zugang zu den Angeboten und der Infrastruktur der UZH ein.</p><em>Beispiele: Die Rampen im Zentrum und im Irchel. Sicherstellung bauliche Barrierefreiheit im Rahmen des strategischen UZH-Projektes «Accessible».</em>' },
        { title: 'Die UZH minimiert ihren ökologischen Fussabdruck', content: '<p>Wir setzen auf effiziente Flächennutzung, Verminderung grauer Energie und Förderung der Kreislaufwirtschaft.</p><em>Beispiele: Turnhallen-Provisorium am Gloriarank. Das Anergienetz am Campus Irchel.</em>' },
        { title: 'Die UZH stärkt die Resilienz', content: '<p>Wir gehen systematisch mit unseren Risiken um, so dass wir stets handlungsfähig sind.</p><em>Beispiel: Initiativen zum Umgang mit Stress und Arbeitslast.</em>' },
        { title: 'Die UZH fördert die Zusammenarbeit', content: '<p>Wir begegnen unseren Partnern innerhalb und ausserhalb der UZH partnerschaftlich und auf Augenhöhe.</p><em>Beispiel: Unsere Werte im Leitbild.</em>' },
        { title: 'Die UZH lebt Good Governance', content: '<p>Wir entwickeln unsere Organisation und unsere Steuerung laufend weiter und berücksichtigen dabei rechtliche und politische Anforderungen.</p><em>Beispiele: Weiterentwicklung Beschaffungswesen. Weiterentwicklung Betriebsdienste. Klärung Delegationsmodell.</em>' },
        { title: 'Die UZH forciert die Digitalisierung', content: '<p>Wir automatisieren unsere Prozesse und basieren unsere Entscheide auf Kennzahlen und Daten.</p><em>Beispiele: Anwesenheitsmessung im West-Park für Flächendisposition. Einführung der digitalen Plattform PROVIS für Bauprojekte und Investitionsplanung.</em>' }
      ],
      prev: 'strategie',
      next: 'hauptziele'
    },

    // HAUPTZIELE
    hauptziele: {
      icon: 'images/2.svg',
      title: '5 Hauptziele',
      subtitle: 'Diese Ziele wollen wir bis 2032 erreichen',
      slider: [
        { title: 'Exzellente Organisation', content: '<p>Unser Steuerungsmodell mit Kanton und UZH ist weiterentwickelt.</p><p>Unsere Prozesse sind aktuell und werden gelebt.</p><p>Der Austausch mit unseren wichtigen Anspruchsgruppen erfolgt effektiv.</p>' },
        { title: 'Systematische Steuerung', content: '<p>Unsere Bauvorhabenpriorisierung ist systematisiert.</p><p>Unser Bau- und Immobilienbetrieb ist resilient und stabil.</p><p>Unser Serviceportfolio ist aktiv bewirtschaftet.</p>' },
        { title: 'Hohe Ressourceneffizienz', content: '<p>Unsere Raumressourcen sind effizient eingesetzt.</p><p>Unsere Betriebs- und Nutzungskosten sind optimiert.</p><p>Unsere Flächenbestellung und -bereitstellung sind systematisiert.</p>' },
        { title: 'Zukunftsfähiges Immobilienportfolio', content: '<p>Unsere Immobilienportfoliostruktur ist optimiert.</p><p>Die Nachhaltigkeit des Bau- und Immobilienmanagements ist vorbildlich.</p><p>Die Immobilienrichtlinien und -konzepte sind etabliert.</p>' },
        { title: 'Digitale Kompetenz und Innovationskraft', content: '<p>Das Datenmanagement stärkt unser Handeln in allen Bereichen.</p><p>Unsere IT-Systemarchitektur ist zeitgemäss und integriert.</p><p>Unsere Innovationskultur wird gelebt.</p>' }
      ],
      prev: 'leitlinien',
      next: 'initiativen'
    },

    // 8 STRATEGISCHE INITIATIVEN (Übersicht)
    initiativen: {
      icon: 'images/1.svg',
      title: '8 Strategische Initiativen',
      subtitle: 'Diese Initiativen sorgen für die Zielerreichung',
      content: `
        <ol class="initiative-list">
          <li data-page="initiative-governance">Weiterentwicklung Governance</li>
          <li data-page="initiative-finanzielle-fuehrung">Finanzielle Führung und Steuerung</li>
          <li data-page="initiative-supply-chain">Supply-Chain-Management</li>
          <li data-page="initiative-portfolio">Weiterentwicklung Portfolio/Stadtuniversität</li>
          <li data-page="initiative-kunden-kommunikation">Kundenkommunikation/Serviceverständnis</li>
          <li data-page="initiative-nachhaltigkeit">Nachhaltigkeit</li>
          <li data-page="initiative-benchmarking">Benchmarking und Prozesse</li>
          <li data-page="initiative-digitalisierung">Digitalisierung</li>
        </ol>
      `,
      prev: 'hauptziele',
      next: 'initiative-governance'
    },

    // EINZELNE INITIATIVEN
    'initiative-governance': {
      icon: 'images/1.svg',
      headerTitle: '8 STRATEGISCHE INITIATIVEN',
      title: 'Weiterentwicklung Governance',
      content: `
        <div class="rich-text-block">
          <p>Wir verbessern das Zusammenarbeitsmodell mit dem Kanton.</p>
          <p>Wir schärfen die Zuständigkeiten der DIB innerhalb der UZH.</p>
        </div>
      `,
      person: { image: 'images/nadine_muller.jpg', name: 'Nadine Müller' },
      prev: 'initiativen',
      next: 'initiative-finanzielle-fuehrung'
    },

    'initiative-finanzielle-fuehrung': {
      icon: 'images/1.svg',
      headerTitle: '8 STRATEGISCHE INITIATIVEN',
      title: 'Finanzielle Führung und Steuerung',
      content: `
        <div class="rich-text-block">
          <p>Wir stärken unsere kennzahlenorientierte Führung.</p>
          <p>Der Fokus liegt beim Immobilien-Portfolio und der Liegenschaftsrechnung.</p>
        </div>
      `,
      person: { image: 'images/martin_ulliana.jpg', name: 'Martin Ulliana' },
      prev: 'initiative-governance',
      next: 'initiative-supply-chain'
    },

    'initiative-supply-chain': {
      icon: 'images/1.svg',
      headerTitle: '8 STRATEGISCHE INITIATIVEN',
      title: 'Supply-Chain-Management',
      content: `
        <div class="rich-text-block">
          <p>Wir systematisieren unser Logistik- und Beschaffungsmanagement.</p>
          <p>Wir setzen eine neue Beschaffungsstrategie um.</p>
        </div>
      `,
      person: { image: 'images/urs_fankhauser.jpg', name: 'Urs Fankhauser' },
      prev: 'initiative-finanzielle-fuehrung',
      next: 'initiative-portfolio'
    },

    'initiative-portfolio': {
      icon: 'images/1.svg',
      headerTitle: '8 STRATEGISCHE INITIATIVEN',
      title: 'Weiterentwicklung Portfolio/Stadtuniversität',
      content: `
        <div class="rich-text-block">
          <p>Wir setzen die neue Immobilienportfoliostrategie um.</p>
          <p>Wir positionieren uns immobilienseitig als Stadtuniversität.</p>
        </div>
      `,
      person: { image: 'images/UZH_Immobilien_Betriebe_MAP_20221713_Bruederli.jpg.jpg', name: 'Christian Saller' },
      prev: 'initiative-supply-chain',
      next: 'initiative-kunden-kommunikation'
    },

    'initiative-kunden-kommunikation': {
      icon: 'images/1.svg',
      headerTitle: '8 STRATEGISCHE INITIATIVEN',
      title: 'Kundenkommunikation/Serviceverständnis',
      content: `
        <div class="rich-text-block">
          <p>Wir verbessern unsere Kommunikation gegenüber den wichtigen Anspruchsgruppen.</p>
          <p>Wir schärfen unser Serviceverständnis.</p>
        </div>
      `,
      person: { image: 'images/reto_hammer.jpg', name: 'Reto Hammer' },
      prev: 'initiative-portfolio',
      next: 'initiative-nachhaltigkeit'
    },

    'initiative-nachhaltigkeit': {
      icon: 'images/1.svg',
      headerTitle: '8 STRATEGISCHE INITIATIVEN',
      title: 'Nachhaltigkeit',
      content: `
        <div class="rich-text-block">
          <p>Wir erarbeiten neue Konzepte und Richtlinien zur Nachhaltigkeit.</p>
          <p>Wir implementieren die Nachhaltigkeit in alle Geschäftsprozesse.</p>
        </div>
      `,
      person: { image: 'images/raphael_muths.jpeg', name: 'Raphael Muths' },
      prev: 'initiative-kunden-kommunikation',
      next: 'initiative-benchmarking'
    },

    'initiative-benchmarking': {
      icon: 'images/1.svg',
      headerTitle: '8 STRATEGISCHE INITIATIVEN',
      title: 'Benchmarking und Prozesse',
      content: `
        <div class="rich-text-block">
          <p>Wir machen gezielt Benchmarking mit vergleichbaren Organisationen im In- und Ausland.</p>
          <p>Wir verschlanken unsere Prozesse auf Basis von «Best Practices».</p>
        </div>
      `,
      person: { image: 'images/valentin_gehrig.jpg', name: 'Valentin Gehrig' },
      prev: 'initiative-nachhaltigkeit',
      next: 'initiative-digitalisierung'
    },

    'initiative-digitalisierung': {
      icon: 'images/1.svg',
      headerTitle: '8 STRATEGISCHE INITIATIVEN',
      title: 'Digitalisierung',
      content: `
        <div class="rich-text-block">
          <p>Wir entwickeln die IT-Infrastruktur in der DIB weiter.</p>
          <p>Wir systematisieren das Datenmanagement über den Immobilienlebenszyklus und das ganze Bau- und Immobilienmanagement.</p>
        </div>
      `,
      person: { image: 'images/marco_spuhler.jpg', name: 'Marco Spühler' },
      prev: 'initiative-benchmarking',
      next: null
    }
  };

  // Klickbare Bereiche auf dem Bild
  const clickableAreas = [
    { id: 'initiative-finanzielle-fuehrung', type: 'poly', pixelCoords: [[472,830], [572,804], [602,882], [511,923], [490,878]] },
    { id: 'initiative-kunden-kommunikation', type: 'poly', pixelCoords: [[539,785], [592,772], [571,730], [532,743]] },
    { id: 'initiative-nachhaltigkeit', type: 'circle', pixelCenter: [727, 837], pixelRadius: 36 },
    { id: 'initiative-supply-chain', type: 'poly', pixelCoords: [[614,768], [673,800], [695,778], [627,732]] },
    { id: 'initiative-benchmarking', type: 'poly', pixelCoords: [[843,743], [876,739], [910,744], [926,764], [936,780], [930,790], [861,810], [848,792], [839,780]] },
    { id: 'initiative-digitalisierung', type: 'circle', pixelCenter: [851, 709], pixelRadius: 30 },
    { id: 'initiative-governance', type: 'poly', pixelCoords: [[880,733], [931,747], [966,720], [956,680], [908,669], [886,681]] },
    { id: 'initiative-portfolio', type: 'poly', pixelCoords: [[871,676], [912,665], [919,627], [883,604], [843,626], [850,660]] }
  ];

  // Seite rendern
  function renderPage(pageId) {
    const page = pages[pageId];
    if (!page) return;

    currentPage = pageId;
    currentSliderIndex = 0;

    const panel = document.getElementById('content-panel');
    panel.classList.add('fade-out');

    setTimeout(() => {
      let html = '';

      // Home-Seite mit Header
      if (pageId === 'home') {
        html = `
          <div class="div-block-12">
            <img src="images/uzh_logo.png" loading="lazy" alt="" class="homelogo">
          </div>
          <h1 class="heading-2 home">${page.title}</h1>
          ${page.content}
        `;
      } else {
        // Icon
        if (page.icon) {
          html += `<img src="${page.icon}" loading="lazy" alt="" class="image-6">`;
        }

        // Header-Titel (für Initiativen)
        if (page.headerTitle) {
          html += `<h1 class="heading-2"><strong>${page.headerTitle}</strong></h1>`;
        }

        // Titel
        html += `<h2 class="heading-2">${page.title}</h2>`;

        // Untertitel
        if (page.subtitle) {
          html += `<h3 class="heading">${page.subtitle}</h3>`;
        }

        // Inhalt
        if (page.content) {
          html += page.content;
        }

        // Slider
        if (page.slider) {
          html += renderSlider(page.slider);
        }

        // Person (für Initiativen)
        if (page.person) {
          html += `
            <div class="initiative-person">
              <img src="${page.person.image}" alt="${page.person.name}">
              <div class="initiative-person-text">Lead:<br><strong>${page.person.name}</strong></div>
            </div>
          `;
        }

        // Navigation
        html += `
          <div class="div-block-6" style="margin-top: 40px;">
            ${page.prev ? `<button class="nav-button back" data-page="${page.prev}"><img src="images/next.svg" alt=""><span style="margin-left:10px;">Zurück</span></button>` : '<div></div>'}
            <button class="nav-button home-btn" data-page="home"><img src="images/home.svg" alt=""><span>Home</span></button>
            ${page.next ? `<button class="nav-button" data-page="${page.next}"><span style="margin-right:10px;">Weiter</span><img src="images/next.svg" alt=""></button>` : '<div></div>'}
          </div>
        `;
      }

      panel.innerHTML = `<div class="div-block-14">${html}</div>`;
      panel.classList.remove('fade-out');

      // Event-Listener für Navigation
      attachEventListeners();

      // Slider initialisieren
      if (page.slider) {
        initSlider();
      }
    }, 150);
  }

  // Slider rendern
  function renderSlider(slides) {
    let slidesHtml = slides.map((slide, index) => `
      <div class="slider-slide">
        <div class="slide-card">
          <h3><strong>${slide.title}</strong></h3>
          ${slide.content}
        </div>
      </div>
    `).join('');

    let dotsHtml = slides.map((_, index) => `
      <button class="slider-dot ${index === 0 ? 'active' : ''}" data-index="${index}"></button>
    `).join('');

    return `
      <div class="slider-container">
        <div class="slider-slides">
          ${slidesHtml}
        </div>
        <div class="slider-arrows">
          <button class="slider-arrow" data-dir="prev">&#8249;</button>
          <button class="slider-arrow" data-dir="next">&#8250;</button>
        </div>
      </div>
      <div class="slider-nav">
        ${dotsHtml}
      </div>
    `;
  }

  // Slider initialisieren
  function initSlider() {
    const container = document.querySelector('.slider-container');
    if (!container) return;

    const slides = container.querySelector('.slider-slides');
    const arrows = container.querySelectorAll('.slider-arrow');
    const dots = document.querySelectorAll('.slider-dot');
    const totalSlides = dots.length;

    function goToSlide(index) {
      if (index < 0) index = totalSlides - 1;
      if (index >= totalSlides) index = 0;
      currentSliderIndex = index;
      slides.style.transform = `translateX(-${index * 100}%)`;
      dots.forEach((dot, i) => dot.classList.toggle('active', i === index));
    }

    arrows.forEach(arrow => {
      arrow.addEventListener('click', () => {
        const dir = arrow.dataset.dir;
        goToSlide(dir === 'next' ? currentSliderIndex + 1 : currentSliderIndex - 1);
      });
    });

    dots.forEach(dot => {
      dot.addEventListener('click', () => {
        goToSlide(parseInt(dot.dataset.index));
      });
    });

    // Touch/Swipe Support
    let touchStartX = 0;
    container.addEventListener('touchstart', (e) => {
      touchStartX = e.touches[0].clientX;
    }, { passive: true });

    container.addEventListener('touchend', (e) => {
      const touchEndX = e.changedTouches[0].clientX;
      const diff = touchStartX - touchEndX;
      if (Math.abs(diff) > 50) {
        goToSlide(diff > 0 ? currentSliderIndex + 1 : currentSliderIndex - 1);
      }
    }, { passive: true });
  }

  // Event-Listener für Navigation
  function attachEventListeners() {
    // Menu-Items und Nav-Buttons
    document.querySelectorAll('[data-page]').forEach(el => {
      el.addEventListener('click', (e) => {
        e.preventDefault();
        const pageId = el.dataset.page;
        if (pages[pageId]) {
          renderPage(pageId);
        }
      });
    });
  }

  // Responsive Image Map für Initiativen
  function createResponsiveOverlays() {
    const bildContainer = document.getElementById('bild-container');
    if (!bildContainer) return;

    let overlayContainer = document.getElementById('responsive-overlay-container');
    if (!overlayContainer) {
      overlayContainer = document.createElement('div');
      overlayContainer.id = 'responsive-overlay-container';
      bildContainer.style.position = 'relative';
      bildContainer.appendChild(overlayContainer);
    }

    overlayContainer.innerHTML = '';

    const svg = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
    svg.setAttribute('viewBox', `0 0 ${ORIGINAL_WIDTH} ${ORIGINAL_HEIGHT}`);
    svg.setAttribute('preserveAspectRatio', 'xMidYMid slice');
    svg.style.cssText = 'position:absolute;top:0;left:0;width:100%;height:100%;pointer-events:none;';

    clickableAreas.forEach(area => {
      const link = document.createElementNS('http://www.w3.org/2000/svg', 'a');
      link.style.pointerEvents = 'auto';
      link.style.cursor = 'pointer';

      let shape;
      if (area.type === 'circle') {
        shape = document.createElementNS('http://www.w3.org/2000/svg', 'circle');
        shape.setAttribute('cx', area.pixelCenter[0]);
        shape.setAttribute('cy', area.pixelCenter[1]);
        shape.setAttribute('r', area.pixelRadius);
      } else if (area.type === 'poly') {
        shape = document.createElementNS('http://www.w3.org/2000/svg', 'polygon');
        const points = area.pixelCoords.map(p => `${p[0]},${p[1]}`).join(' ');
        shape.setAttribute('points', points);
      }

      if (shape) {
        shape.style.cssText = 'fill:rgba(0, 40, 165, 0.15);stroke:rgba(0, 40, 165, 0.4);stroke-width:2;cursor:pointer;transition:fill 0.2s ease, stroke 0.2s ease;';
        shape.addEventListener('mouseenter', function() {
          this.style.fill = 'rgba(0, 40, 165, 0.35)';
          this.style.stroke = 'rgba(0, 40, 165, 0.7)';
        });
        shape.addEventListener('mouseleave', function() {
          this.style.fill = 'rgba(0, 40, 165, 0.15)';
          this.style.stroke = 'rgba(0, 40, 165, 0.4)';
        });
        shape.addEventListener('click', () => renderPage(area.id));
        shape.addEventListener('touchstart', function() {
          this.style.fill = 'rgba(0, 40, 165, 0.35)';
          this.style.stroke = 'rgba(0, 40, 165, 0.7)';
        }, { passive: true });
        shape.addEventListener('touchend', function() {
          this.style.fill = 'rgba(0, 40, 165, 0.15)';
          this.style.stroke = 'rgba(0, 40, 165, 0.4)';
        }, { passive: true });

        link.appendChild(shape);
        svg.appendChild(link);
      }
    });

    overlayContainer.appendChild(svg);
  }

  // Initialisierung
  function init() {
    renderPage('home');
    createResponsiveOverlays();
  }

  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', init);
  } else {
    init();
  }

  // Resize-Handler
  let resizeTimeout;
  window.addEventListener('resize', function() {
    clearTimeout(resizeTimeout);
    resizeTimeout = setTimeout(createResponsiveOverlays, 100);
  });
})();
